{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 * Data inici: 26/12/2004
 * Ultim dia:  26/12/2004
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

{***********************************************************************
GLOBUS 3 - Form FRACTAL MANDELBROT
***********************************************************************}

unit UnitFormFractal;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, MMSystem, StdCtrls;

type
  TFormFractal = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    SpeedButtonCaixaEines: TSpeedButton;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    RadioButton5: TRadioButton;
    RadioButton6: TRadioButton;
    RadioButton7: TRadioButton;
    CheckBoxNoIniciar: TCheckBox;
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButtonCaixaEinesClick(Sender: TObject);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
  end;

var
  FormFractal: TFormFractal;
  pal:(norm, psy1, psy2, psy3, psy4, pal1, pal2);
  m,i2,l,h,maxi:integer;
  c1,c2,x,y,x1,y1,z,minx,maxx,miny,maxy:Real;

{************************************************}
IMPLEMENTATION
{************************************************}

uses ShellApi, UnitEntradaSo, UnitCanviDeparametres, UnitTools, TLHelp32;

{$R *.DFM}
{
function tan(x:Extended):Extended;
begin
  tan:=sin(x)/cos(x);
end;
}
function Tan(X: Extended): Extended;
{  Tan := Sin(X) / Cos(X) }
asm
  FLD    X
  FPTAN
  FSTP   ST(0)      { FPTAN pushes 1.0 after result }
  FWAIT
end;

function Floor(X: Extended): Integer;
begin
  Result := Integer(Trunc(X));
  if Frac(X) < 0 then Dec(Result);
end;

procedure TFormFractal.FormClose(Sender: TObject;var Action: TCloseAction);
begin
  if not (SpeedButtonEngegarParar.Caption='E') then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
  end;
end;

procedure TFormFractal.SpeedButtonEngegarPararClick(Sender: TObject);
begin
  if SpeedButtonEngegarParar.Caption='E' then begin
    SpeedButtonEngegarParar.Caption:='P';
    RePaint;
    IniciarDadesUnitEntradaSo(512);
    EngegarProcesEntradaSo(Handle);
    if RadioButton1.Checked then begin
      pal:=norm;
    end else if RadioButton2.Checked then begin
      pal:=psy1;
    end else if RadioButton3.Checked then begin
      pal:=psy2;
    end else if RadioButton4.Checked then begin
      pal:=psy4;
    end else if RadioButton5.Checked then begin
      pal:=pal1;
    end else if RadioButton6.Checked then begin
      pal:=pal2;
    end else if RadioButton7.Checked then begin
      pal:=psy3;
    end;
    minx := -2;
    maxx := 1.5;
    miny := -2;
    maxy := 2;
    maxi := 70;
    //Cursor := crHourGlass;
    l := FormFractal.ClientWidth;
    h := FormFractal.ClientHeight;
    if not Odd(h) then Dec(h);
    m:=0;
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
  end;
end;

procedure TFormFractal.WMWIMDATA(var Msg: TMessage);
var
  k,i,Max,n:integer;
begin
  Max:=0;
  For i:=1 to BytesBuffer do if so[NumeroBufer,i]-127>Max then Max:=so[NumeroBufer,i]-127;
  if Max>ValorMinim then begin
    if m<l then begin
      for k:=0 to 19 do begin
        Application.ProcessMessages;
        for n:=0 to h do begin
          c1 := minx + m/(l/(maxx - minx));
          c2 := maxy - n/(h/(maxy - miny));
          x := c1;
          y := c2;
          for i := 0 to maxi do begin
            x1 := sqr(x) - sqr(y) + c1;
            y1 := 2*x*y + c2;
            x := x1;
            y := y1;
            z := sqr(x) + sqr(y);
            if (z > 4) then break;
          end;
          i2 := Floor((i/maxi)*255);
          try
            Case pal of
              norm: Canvas.Pixels[m, n] := RGB(Trunc(i2*Abs(tan(x)*cos(x))), Trunc(i2*Abs(sin(y)*cos(x))), i2);
              pal1: Canvas.Pixels[m, n] := RGB(Trunc(i2*Abs(cos(x)*tan(x)*tan(x))), Trunc(i2*Abs(sin(y)*tan(x)*tan(x))), i2);
              pal2: Canvas.Pixels[m, n] := RGB(Trunc(i2*Abs(sin(x)*sin(x))), Trunc(i2*Abs(cos(y)*cos(x))), i2);
              psy1: Canvas.Pixels[m, n] := RGB(Trunc(i2*Abs(cos(x)/tan(y))), Trunc(i2*Abs(sin(x)/tan(y))), i2);
              psy2: Canvas.Pixels[m, n] := RGB(Trunc(i2*Abs(cos(x/y))), Trunc(i2*Abs(sin(x/y))), Trunc(i2*Abs(tan(y/x))));
              psy3: Canvas.Pixels[m, n] := RGB(Trunc(i2*Abs(tan(x)*tan(x))), Trunc(i2*Abs(tan(y)*tan(y))), Trunc(i2*Abs(tan(x)*tan(y))));
              psy4: Canvas.Pixels[m, n] := RGB(Trunc(i2*Abs(cos(y)*tan(x))), Trunc(i2*Abs(sin(x)*tan(x))), Trunc(i2*Abs(sin(y)*cos(x)*tan(x*y))));
            end;
          except
          end;
        end;
        inc(m);
      end;
    end;
  end else begin
    if m<l then begin
      if not CheckBoxNoIniciar.Checked then begin
        m:=0;
        Repaint;
      end;
    end else begin
      PararEntradaSo;
      FinalitzarEntradaSo;
      SpeedButtonEngegarParar.Caption:='E';
      SpeedButtonEngegarParar.down:=false;
    end;
  end;
  EntradaSo;
end;

procedure TFormFractal.SpeedButtonCaixaEinesClick(Sender: TObject);
begin
  FormCanviDeParametres.ShowModal;
end;

procedure TFormFractal.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=ClientRect.Bottom;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

procedure TFormFractal.FormMouseDown(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbleft then begin
  end else begin
    if not (SpeedButtonEngegarParar.Caption='E') then begin
      PararEntradaSo;
      FinalitzarEntradaSo;
      SpeedButtonEngegarParar.Caption:='E';
      SpeedButtonEngegarParar.Down:=false;
    end;
  end;
end;

end.

